/* loads all libraries, initializes all */
LL=OpenLog("LL")

/** LOAD All Libraries **/

// load system libraries
RequireSystemScript('screen.js');
RequireSystemScript('time.js');

// load custom libs
RequireScript('gui.js');
RequireScript('characters.js');
RequireScript('Menu.js');
RequireScript('library/lithonite.js'); // Anti obstruction library
RequireScript('library/spritefactory.js'); // Spriteset swap and mix library
RequireScript('library/teleporthica.js'); // Include the map change library
RequireScript('library/acusthica.js'); // Include the sound library
RequireScript('library/plethora.js'); // Include the Cutscene event handler
RequireScript('library/cinemathica.js'); // Include the camera library, will create the Camera object and some functions
RequireScript('library/ainimation.js'); // Include the sprite animation library
RequireScript('library/esthetica.js'); // Include the sfx library
RequireScript('library/phenibut.js'); // Include pushing blocks and stepping on switches.
RequireScript('library/ethernum.js'); // Pause library
RequireScript('library/clockengine.js'); // Time library
RequireScript('library/precipitation.js'); // Include rain and snow
RequireScript('library/bibliotheca.js'); // Load and save
RequireScript('library/objects.js'); // Include objects library
RequireScript('library/dynalayer.js'); // Include objects library

RequireScript('library/rethorica.js'); // Include the (broken) textbox and (working) text balloon library
RequireScript('kcl/kcl.js'); // Include a working textbox library
RequireScript('library/persist.js'); // Include Tunginobi's persist release.

// load temporary files
RequireScript('library/minimap.js'); // Include Flik's minimap (used to snapshot maps)

/** INITIALIZE all libraries **/


// Initialize Daniel, our main character
var Daniel="Daniel";
CreatePerson(Daniel, "daniel.rss", false);

// Holds a snapshot of the latest mapchange, useful for saving. 
Game.Snapshot = {screen:undefined};


var sav = new Bibliotheca("slot1.sav"); sav.storeFunctions=false;
var autosave = new Bibliotheca("autosave.sav"); autosave.storeFunctions=false;


// Initialize Teleporthica, it already automatically created the variable MapChange for us.

// Initialize persist and put it in the Game, but keep the global variable too or it doesnt work.
Game.persist = persist;
Game.persist.init();

/** Persistant FLAGS (they are loaded and saved)
 * Object to hold events that have happened. Do not confuse with EventMarker[], which can be resetted 
 * each time a cutscene starts.  FLAGS.MAP will tell us how many times we have visited a certain map. 
 * We can check things like:
 *     if(FLAGS.MAP[GetCurrentMap()].visited) {...};
 *     if(FLAGS.MAP[GetCurrentMap()].hasgrabbedtheloot) {...}; // dont use this, use ScriptBind's FLAG.WORLD[<mapname>].<variable>
 * To reach a person variable: FLAG.WORLD[<mapname>].personname.variable // or just use persist.world
 * Note that you should not use: if(FLAGS.myevent1==true){...};
 */
var FLAGS = { MAP: MapChange.maps, WORLD: persist.getWorldState() };

function hasHappened(it,val){ if(val==undefined) return FLAGS.WORLD[it]; return FLAGS.WORLD[it]=val; }

//Overload Teleporthica with our stuff. Make it show the map's name at entry
MapChange.showName=function(){if(WARP.mapname)Game.rethorica.printTitle(WARP.mapname,3);else Game.rethorica.Title.show=function(){};}

//Overload Teleporthica. Autosave at each level/teleport/warp! Create a screenshot for savegame. A savedgame restores to a Warppoint, 
//so its the ideal place. (a bit slow though to do it at each ChangeMap()/Warp() and it messes up some fadein/fadeout scripts, cant have everything...)
MapChange.initmap=function(){
        SetColorMask(CreateColor(255, 255, 255, 0),0, 'initmap no mask'); //Remove the blackfadeout from the mapengine (will be overwritten soon by fadein anyways.
        UpdateMapEngine(); //Update the mapengine, so our PC is warped to its place (default is centered at entrypoint), 
	Game.lithonite.DynaCheck(); // Enables/Disabled DynaLayer and returns a boolean
        RenderMap(); //then render the map to the buffer, but do not call flip screen.
        Game.Snapshot.screen = GrabSurface(0, 0, GetScreenWidth(), GetScreenHeight()); //Grab the screen
        Game.Snapshot.screen.rescale(GetScreenWidth()>>2, GetScreenHeight()>>2); //resize it
        //MapChange.updateCurrentInfo(); //Update our current position. already done within repos();
        Game.Snapshot.MapChange=new Object();
        Game.Snapshot.MapChange.previous =CloneObj(MapChange.previous);
        Game.Snapshot.MapChange.current=CloneObj(MapChange.current);
        Game.Snapshot.MapChange.entryPoint=CloneObj(MapChange.entryPoint);
        Game.Snapshot.MapChange.warpid=MapChange.warpid;
        Game.Snapshot.MapChange.oldwarpid=MapChange.oldwarpid;
        Game.Snapshot.MapChange.GIP=MapChange.GIP;
	Game.Snapshot.EventMarker=Game.lithonite.EventMarker;
	Game.Snapshot.FLAGS=CloneObj(FLAGS);
	//Game.Snapshot.Clock=CloneObj(Clock);
	//Game.Snapshot.Party=CloneObj(Party); //GetPersonData(Game.lithonite.GIP);
	autosave.storeFunctions=false;
	//autosave.store("MapChange","EventMarker", "Clock", "FLAGS"); //"Inventory","", "STATUS",
	autosave.store("MapChange","Game.lithonite.EventMarker", "FLAGS"); //"Inventory","", "STATUS", //TODO:cleanup
	autosave.flush();
	//ScreenImage.save(MapChange.current.rmp+'.sav.png'); //save it

	Game.lithonite.resetSpeed();
}

// Define initmap() as the Teleporthica's postWarp function.
MapChange.postWarp = MapChange.initmap; 

// Things to do before a MapChange()
MapChange.preWarp = function(){
	if(Game.lithonite.DynaLayerActive)
		Game.lithonite.DynaClear(); // Clears DynaLayer code.
}


//----------------------------------------------------------------------------//


// The keys used in this game, wrapped together in an object.
Game.Keys = {
	talk:   KEY_CTRL, //linked to Game.keyConfirm through setter Game.Keys.action
	run:    KEY_SHIFT,
	pause:  KEY_TAB,
	inventory: KEY_ALT,
	menu:   KEY_ESCAPE,
	qsave:  KEY_F2,
	qload:  KEY_F3,
	help:   KEY_F1,

	// Game.action now holds the 'action' key. This may be confusing if 'action' means hit, while you want to talk to someone...
	get action(){
		return Game.Keys.talk;
	},
	set action(x){
		Game.keyConfirm = x;
		Game.Keys.talk = x;
	}
}

	// make the kcl textbox also continue using KEY_CTRL instead of enter
	Game.Keys.action = Game.Keys.talk;

	// Read the userdefined Keys from a file, if it exists.
	sav.setFilename("keys.dat");
	if(sav.FileExists()) sav.restore("Game.Keys");
	sav.close();


// Initialize the Sound Library
Game.music = new AcusthicaEngine();

// Include the event/cutscenes library
Game.EventQueue = new PlethoraEngine('Game.EventQueue');

// Include the textbox and speech library
Game.rethorica= new RethoricaEngine("Game.rethorica",undefined,GetSystemWindowStyle(),"Main.rws",true,Game.Keys.talk,undefined, undefined);
	 Game.rethorica.InitBalloon("blue.rws",undefined,"system/topballoon.png","system/bottomballoon.png");
	 //SetFrameRate(60); //Limit Game.rethorica's framerate
	 //TextBox=function(max,msg,img){Game.rethorica.TextBox(max,msg,img)};
	 Game.rethorica.InitBorder(16,16);


// Include the anti-obstruction library
Game.lithonite = new LithoniteEngine("Game.lithonite");
	//ShortWrites.
	function slope(c){Game.lithonite.enZone(c)}; //short-write as a function, deprecated
	function zone(c){Game.lithonite.enZone(c)}; //short-write as a function
	testFromUntil = Game.lithonite.testFromUntil; //short-write can be done like this too
	Pushable = Game.lithonite.Pushable;
	Game.lithonite.LMaxLookupX = 13; //how many pixels are we going to check to the sides to de-obstruct our sprite
	Game.lithonite.LMaxLookupY = 13; //The same, but in the Y axis.
	SetTalkDistance(32>>1); // Default == 8;

	Game.lithonite.setInputPerson(Daniel);
	Game.lithonite.setCameraPerson(Daniel);
	Game.lithonite.setSpeeds(1.75,1.75, 4,4, 1,1); // Define the speeds of Daniel
	Game.lithonite.rectifySpeed(); // Set the default speeds for Daniel
	Game.lithonite.SaveDirections(Daniel, 'default', true);
	Game.lithonite.face = "look";  // Default face prefix.


// Initialize Esthetica, the SFX library
        Spotlight.offset=-4; //vertical offset from center of sprite's base.
        Spotlight.init();


// Initialize the sprite animation library
	Game.lithonite.EmotionsInit();
	Game.lithonite.EMOTIONS.emoticonFollowsSprite=true; //Emoticon now follows sprite
	Game.lithonite.EMOTIONS.loadEmoticon("sfx/arrowticons.rss",true); //Load all arrowtions, they follow the sprite
	Game.lithonite.EMOTIONS.loadEmoticon("sfx/emoticons.rss",true); //Load all emotions, they follow the sprite
	Game.lithonite.ActionsInit();

// Initialize Dynamic Layering. Up to 3 tiles above Daniel have to be checked. (The default value is 2). Boundary checking is true.
	Game.lithonite.DynaLayerInit(3,true);

// Overload SetPersonLayer with DynaLayer checking code (we actually replace the original function):
if(typeof SetPersonLayer_ == 'undefined'){
	SetPersonLayer_ = SetPersonLayer;
}
SetPersonLayer = function(name, layer){
	if(name != Game.lithonite.GIP) return SetPersonLayer_(name, layer);
	SetPersonLayer_(name, layer);
	Game.lithonite.DynaLayerUpdate();
}


// Initialize Game.pause library
Game.pause = new EthernumEngine(Game.Keys.pause, Game.Keys.pause, undefined, undefined,
	"'PAUSED, press TAB to continue'"
);
	//calls 'Movement_Update()' before all map layers are rendered
	Game.pause.SetHookUpdateScript(Movement_Update);
	Game.pause.SetHookUpdateScript("Movement_Update_Cutscenes()", 'CutScene');
	// calls 'Render_Update()'  after  all map layers are rendered
	Game.pause.SetHookRenderScript("Render_Update()");
	Game.pause.HookUpdateAndRender(); //Now make them active.
	Game.pause.SetAudio(Game.music); //make bgm sound also pause when pause is active
	//Game.pause.SetTimer(Clock); //make timer clock also pause
	Game.rethorica.Ethernum=Game.pause; //If using Game.rethorica, link it to the pause.

Game.clock = new ClockEngine();
	Game.pause.SetTimer(Game.clock);
	// Redefines GetTime() so when we pause, the game continues perfectly.
	// The other option is to NOT use GetTime() in the game, but Clock.getMs();

// Initialize rain and snow
//	Game.SnowField = new SnowFactory(100,  LoadImage("sfx/snowflake.png") ,true,1);
//	Game.RainField = new RainFactory(50,"sfx/rainfx.rss","splash",true,-2,8,40,0,.002);


// Initialize SpriteMixing routines
Game.mixrss = new SpriteFactory();

// Define initial color matrices in Game object.
// Note that esthetica.js creates it as global variable, but kclWrapperClasses.js redefines it as a contructor, so we blend the functionality.
Game.ColorMatrix = ColorMatrix;
ColorMatrix["Swap_red_and_blue"]   = CreateColorMatrix(0, 0,0,255,  0, 0,255,0,  0, 255,0,0),
ColorMatrix["Swap_blue_and_green"] = CreateColorMatrix(0, 255,0,0,  0, 0,0,255,  0, 0,255,0),
ColorMatrix["Swap_green_and_red"]  = CreateColorMatrix(0, 0,255,0,  0, 255,0,0,  0, 0,0,255),
ColorMatrix["Rotate_forth"]        = CreateColorMatrix(0, 0,255,0,  0, 0,0,255,  0, 255,0,0),
ColorMatrix["Rotate_back"]         = CreateColorMatrix(0, 0,0,255,  0, 255,0,0,  0, 0,255,0),
ColorMatrix["Reverse"]    = CreateColorMatrix(0, 0,255,255,  0, 255,0,255,  0, 255,255,0),
ColorMatrix["grayscale"]  = CreateColorMatrix(0, 85,85,85,  0, 85,85,85,  0, 85,85,85),
ColorMatrix["lighten20"]  = CreateColorMatrix(20, 255,0,0,  20, 0,255,0,  20, 0,0,255),
ColorMatrix["darken20"]   = CreateColorMatrix(-20, 255,0,0,  -20, 0,255,0,  -20, 0,0,255),
ColorMatrix["hue_red"]    = CreateColorMatrix(20, 255,0,0,  0, 0,255,0,  0, 0,0,255),
ColorMatrix["hue_green"]  = CreateColorMatrix(0, 255,0,0,  20, 0,255,0,  0, 0,0,255),
ColorMatrix["hue_blue"]   = CreateColorMatrix(0, 255,0,0,  0, 0,255,0,  20, 0,0,255),
ColorMatrix["hue_red55"]  = CreateColorMatrix(55, 200,0,0,  0, 0,200,0,  0, 0,0,200),
ColorMatrix["hue_green55"]= CreateColorMatrix(0, 200,0,0,  55, 0,200,0,  0, 0,0,200),
ColorMatrix["hue_blue55"] = CreateColorMatrix(0, 200,0,0,  0, 0,200,0,  55, 0,0,200),




// Initialize and define the language to create the cutscenes
RequireScript('cutscenes/language.js');


// Set the default map transition sfx
//MapChange.setFade('spot');
//MapChange.setFade('grayfade');
//MapChange.setFade('stripeout');
//MapChange.setFade('pixelate');
//MapChange.setFade('zoom');

GetSystemFont().drawText(20,10, " Initializing libraries... "); FlipScreen();
Game.log.info('Initializing libraries');


//----------------------------------------------------------------------------//

// With a reduced set of things, note, we dont check for checkDashing and other functions...
function Movement_Update_Cutscenes(){
	while (AreKeysLeft()) {
		switch (GetKey()) {
			case Game.Keys.pause:
				Game.pause.run();
			break;
			case Game.Keys.menu:
				// Add here a Menu
			break;
		}
	}
        Game.lithonite.DynaLayer();
	Game.lithonite.doZone();
	if (Game.lithonite.justStopped())
		Game.lithonite.standStill('look');
}

// The extra if(IsKeyPressed(GetTalkActivationKey())... is because talk is only checked in directions north/south/west/east and not in looknorth/etc.
function Movement_Update() {
	OnKEYDown(); 
	if (Game.lithonite.justStopped())
		OnKEYUp();
	if(IsKeyPressed(GetTalkActivationKey())&&Game.lithonite.moving==0){
		QueuePersonCommand(Game.lithonite.GIP, Game.lithonite.getCommand(0,Game.lithonite.hist_x,Game.lithonite.hist_y),true);
		Game.lithonite.moving=1;
	}
}

/**
 * What happens when no keys are pressed? Then we call OnKEYUp()
 */
// standStill() Sets a face_<> direction and unsets justStopped(), justStopped() is now false again.
function OnKEYUp(){
	Game.lithonite.standStill('look');
}

//Status bar is displayed? (disabled/false during cutscenes)
Game.Do_StatBar = true;

function OnKEYDown() {
	//#Read Inputbuffer for NON-retriggering events.(for example: toggle's)
	while (AreKeysLeft()) {
		switch (GetKey()) {
			case Game.Keys.pause:
				Game.pause.run();
			break;
			case Game.Keys.menu:  //TODO: Replace with a REAL menu ;)
				Game.music.stop();
				Game.EventQueue.reset();
				MapChange.done();
				ExitMapEngine(); 
			break; //Exit is called, but the renderscript will run 1 last time, we dont want that.
			case KEY_F5:
				RestartGame();
			break;
			case KEY_S:
				Game.Do_StatBar = !Game.Do_StatBar; 
			break;
			case Game.Keys.help: 
				showhelp = !showhelp;
			break;
			case KEY_OPENBRACE:
				IgnoreTileObstructions(Game.lithonite.GIP, true);
			break;
			case KEY_CLOSEBRACE:
				IgnoreTileObstructions(Game.lithonite.GIP, false);
			break;
			// TODO: Debugging. Deleteme later
			case KEY_1:
				SetMapFlag('HasAccessOutsideOfKamajsReturn',1)

			break;
			// A little map image saver to have the maps as pictures
			case KEY_8:
				var image = CurrentMapToSurface();
				var name = GetCurrentMap().split("/").reverse()[0]+".png";
				image.save(name);
				delete(image);
			break;
		}
	}

	// Calling this each time Movement_Update() is called is redundant, 
	// but its very safe. All the actions like checkDashing() and 
	// calcVectors() are checked against this InputPerson.
	// So if you never will swap your input person, you can call this 
	// once. In game(), for example, with parameters, like this:
	// Game.lithonite.setInputPerson("Daniel");
	Game.lithonite.setInputPerson(Game.lithonite.GIP);

	//#DashAlgorithm: Check and activate dashing
	Game.lithonite.checkDashing(Game.Keys.run);

	// Calculate Lithonite vectors
	if(Game.lithonite.calcVectors()){
		Game.lithonite.deObstruct();
		Game.lithonite.DynaLayer();
	};
	Game.lithonite.doZone(); // Use to add movement effects in a zone.
}//End_Function:OnKEYDown


// Render_Update_Cutscenes() is the same as Render_Update
// Render_Update_Worldmap() could contain more HUD information and contain 3D 'mode X' renderization. But in this game we dont have that.

function Render_Update(){
	Camera.UpdateAndDraw();
	//Game.SnowField.UpdateAndDraw();
	//Game.RainField.UpdateAndDraw();
	Game.EventQueue.UpdateAndDraw();
	Esthetica.UpdateAndDraw(); 
	MapChange.UpdateAndDraw();
	Game.rethorica.UpdateAndDraw();
	Game.lithonite.doIdle();
	return;
	//PUT HUD here (and remove the return)
	debugfont=GetSystemFont(); //FOR DEBUG
	debugfont.drawText(0,4+8,"?="+Game.EventQueue.active+ " "+ Game.EventQueue.waiting + " "+Game.EventQueue.frames);
	debugfont.drawText(100,80, Game.EventQueue.EventQueue[0]);
	debugfont.drawTextBox(10,90,GetScreenWidth()-20,30, 0, Game.EventQueue.EventQueue[1]);
	debugfont.drawTextBox(10,120,GetScreenWidth()-20,30, 0, Game.EventQueue.EventQueue[2]);
	debugfont.drawTextBox(10,160,GetScreenWidth()-20,70, 0, Game.EventQueue.UpdateAndDraw.toString());
}

/**
 * Render update script when inside a wagon
 */
function Render_Update_wagon(){
	// The usual rendering things here
	Camera.UpdateAndDraw();
	Game.EventQueue.UpdateAndDraw();
	Esthetica.UpdateAndDraw();
	MapChange.UpdateAndDraw();
	Game.rethorica.UpdateAndDraw();

	// Now if the tile we are standing on is not our previous tile, set it as our current tile and call any triggers on this tile
	// (Because the cursorkeys are detached, we're not actually triggering triggers, pun not intended)
	if(this.tx != (GetPersonX(Game.lithonite.GIP)>>4) || this.ty != (GetPersonY(Game.lithonite.GIP)>>4) ){
		Movement_Update_wagon.dirs = false; 
		Game.lithonite.moving=3;
		this.tx = GetPersonX(Game.lithonite.GIP)>>4;
		this.ty = GetPersonY(Game.lithonite.GIP)>>4;
		Entrigger(Game.lithonite.GIP);
	}
	return;
	// TEMPORAL DEBUGGING
	tx = GetPersonX(Game.lithonite.GIP)>>4;
	ty = GetPersonY(Game.lithonite.GIP)>>4;
	ti = Game.lithonite.GetCurrentTile(undefined,true);
	tn = ti == -1 ? "NAN" : GetTileName(ti);
	debugfont=GetSystemFont();
	debugfont.drawText(10,20, "tx="+tx+" ty="+ty+" ti="+ti+" tn="+tn + " "
		+ Game.lithonite.getMoveDir(1,1) 
		+ " spdX="+GetPersonSpeedX(Game.lithonite.GIP)
		+" cgm:"+GetPersonValue(Game.lithonite.GIP,'cgmove'));
	debugfont.drawText(10,40, "mx="+Game.lithonite.move_x+" my="+Game.lithonite.move_y+" hx="+Game.lithonite.hist_x+" hy="+Game.lithonite.hist_x);
}
Render_Update_wagon.tx = 0; // sneekily adding persistent local variables to the function Render_Update_wagon()
Render_Update_wagon.ty = 0; // They represent the tile X Y coordinates we're standing on.

/**
 * Movement update script when inside a wagon. Called from MountWagon()
 * While riding a wagon, we are checking the tilename we are standing on, tiles that have a naming starting with '%' tell us we are on a track.
 * If the name of the tile is exactly '%' we continue moving in the direction we are currently moving.
 * If the name of the tile is %abcdefgh (8 hexadecimal numbers) then we can move in certain directions. The first pair of integers indicate
 * the possible cursor keys we can push to move into that new direction, using a mask of North=1, East=2, West=4, South=8 so, if we can go south and west
 * thats 4 + 8 = 12 = C
 * %  : Starting marker
 * ab : a: possible directions moving north b: default continuing direction moving north  
 * cd : c: possible directions moving east  d: default continuing direction moving east
 * ef : e: possible directions moving west  f: default continuing direction moving west
 * gh : g: possible directions moving south h: default continuing direction moving south
 *
 */
function Movement_Update_wagon(){

	// Read keys
        while (AreKeysLeft()) {
                switch (GetKey()) {
                        case Game.Keys.pause:
                                Game.pause.run();
                        break;
                        case Game.Keys.menu:
                                // Add here a Menu that should be activated when inside a wagon (maybe the same as when walking around?)
                        break;
			//A little map image saver to have the maps as pictures
			case KEY_8:
				var image = CurrentMapToSurface();
				image.save(GetCurrentMap()+".png");
				delete(image);
			break;

                }
        }

        Game.lithonite.DynaLayer();
        Game.lithonite.doZone();

	// Only move automatically if we're not moving because of AddCGMove(). This way we actually move and evaluate bearings per-tile.
	if(!GetPersonValue(Game.lithonite.GIP,'cgmove')){

		// Center on the tile we are standing on
		Game.lithonite.recenter();

		// Are we on a tile that can change our direction? Lets see
		var tile = Game.lithonite.GetCurrentTile(Game.lithonite.GIP,true);
		if(tile<0) return; 
		tile = GetTileName(tile);
		var currentdirection = GetPersonDirection(Game.lithonite.GIP);

		// Reset our probable directions
		this.dirs = { 'north':{}, 'east':{}, 'west':{}, 'south':{}  };

		// If we stand on a tile with name '%', then just continue one tile more in that direction.
		if(tile == '%'){
			Game.lithonite.AddCGMove( Game.lithonite.GIP, currentdirection[0] , true,false);
			return 1;
		}

		// And if we stand on a tile that does not start with '%', then we actually derailed, unmount.
		if(tile[0] != '%') {
			UnMountWagon();
			return -1;
		}

		var i = 1,n = 0;
		for(var o in this.dirs){

			// Change our hexadecimal letter to an integer
			n = parseInt(tile[i], 16);

			// Decode valid exit directions for entrance direction 'o'
			if(n & 1) this.dirs[o].KEY_UP = 'Nn';
			if(n & 2) this.dirs[o].KEY_RIGHT = 'Ee';
			if(n & 4) this.dirs[o].KEY_LEFT = 'Ww';
			if(n & 8) this.dirs[o].KEY_DOWN = 'Ss';
			++i;

			// Decode default exit direction
			n = parseInt(tile[i], 16);
			if(n & 1) this.dirs[o]['default'] = 'Nn';
			if(n & 2) this.dirs[o]['default'] = 'Ee';
			if(n & 4) this.dirs[o]['default'] = 'Ww';
			if(n & 8) this.dirs[o]['default'] = 'Ss';
			++i;
		}

		if( IsKeyPressed(KEY_UP) && (this.dirs[currentdirection]['KEY_UP']) ){
			Game.lithonite.AddCGMove(Game.lithonite.GIP, this.dirs[currentdirection]['KEY_UP'], true,false);
		}else if( IsKeyPressed(KEY_DOWN) && (this.dirs[currentdirection]['KEY_DOWN']) ){
			Game.lithonite.AddCGMove(Game.lithonite.GIP, this.dirs[currentdirection]['KEY_DOWN'], true,false);
		}else if( IsKeyPressed(KEY_LEFT) && (this.dirs[currentdirection]['KEY_LEFT']) ){
			Game.lithonite.AddCGMove(Game.lithonite.GIP, this.dirs[currentdirection]['KEY_LEFT'], true,false);
		}else if( IsKeyPressed(KEY_RIGHT) && (this.dirs[currentdirection]['KEY_RIGHT']) ){
			Game.lithonite.AddCGMove(Game.lithonite.GIP, this.dirs[currentdirection]['KEY_RIGHT'], true,false);
		}else if(this.dirs[currentdirection]['default']){
			Game.lithonite.AddCGMove(Game.lithonite.GIP, this.dirs[currentdirection]['default'], true,false);
		}else{
			// Ugh! bad map design!
			Abort( "Stuck on tile " + tile + " in map" + GetCurrentMap() + " at ("+ Render_Update_wagon.tx + "," + Render_Update_wagon.ty + ")" );
		}
	}
}
Movement_Update_wagon.dirs = false;

/**
 * This function shows flashing arrows above your player, to make the player understand that (s)he has to use the cursors to move
 * In this game, when using a wagon and pressing a trigger on the track will activate it. This code looks like so:
 * // First make sure we are in a wagon, this is done by checking 'moving', which is set to 3 (Game.lithonite.moving=3;) in MountWagon()
 *    ActionArrows( { north:['east','west'] }, 2 );
 * @param {object} o directional object. It contains a direction and then an array of arrows to show when travelling in that direction.
 * 	So calling it like this: ActionArrows( { north:['east','west'] } );  will activate flashing arrows to the east and west but only if we are walking north
 * @param {integer} n Optional. The value that Game.lithonite.moving should have to be activated. (We use '3' in this game). Leave empty to always display
 */
function ActionArrows(o,n){
	if(n)
		if (Game.lithonite.moving != n) return;
	var dir = GetPersonDirection(Game.lithonite.GIP);
	if(!o[dir]){
		Game.log.info('No Arrow info for direction '+dir);
		return;
	}
	var i = o[dir].length-1;
	do{
		Game.log.info("Emotion "+i+" arrow_"+o[dir][i]);
		Game.lithonite.EMOTIONS.setEmoticon("sfx/arrowticons.rss",'arrow_'+o[dir][i], Game.lithonite.GIP); 
	}while(i--);
}

/**
 * Called from a wagon's talking script
 * @param {string} wagon Name of the spriteset we will jump on
 */
function MountWagon(wagon){
	Game.log.info("MountWagon "+wagon);

	// Do not ask to mount the wagon if we are in a cinematic sequence
	if(Game.lithonite.moving>2) return;

	Game.log.info("MountWagon Question1"+wagon);

	// Confirm we want to hop on to a wagon
	if(!Game.rethorica.QuestionBox( [
		{ret:1, txt:"Yes,Get in!"}, 
		{ret:0, txt:"Forget it!"},] , 
		"Get in?" ) ) return;

	Game.log.info("Wagonizing moving=3");

	// Detach normal movement, we are not free to roam anymore.
	Game.lithonite.moving=3;
	Game.lithonite.DetachAll();
	IgnoreTileObstructions(Game.lithonite.GIP, true);
	IgnorePersonObstructions(Game.lithonite.GIP, true);

	// Now swap the spriteset, and set the directions where Daniel is inside the wagon
	Game.lithonite.clearDirs();
	SetPersonSpriteset(Game.lithonite.GIP, LoadSpriteset("objects/wagon.rss") );
	Game.lithonite.SwapDirections(Daniel);

	// Now put ourselves on the spot where the empty wagon is, facing the same direction.
	// Then fix the lithonite vectors, destroy the empty wagon and slowly pan the camera to the new spot.
	Game.lithonite.reposNextTo(wagon,0,0,Game.lithonite.GIP, true);
	SetPersonDirection(Game.lithonite.GIP, GetPersonDirection(wagon));
	var DirVector = Game.lithonite.Move2Vector( Game.lithonite.getDirMove(GetPersonDirection(wagon)) );
	Game.lithonite.hist_x = DirVector.x;
	Game.lithonite.hist_y = DirVector.y;
	DestroyPerson(wagon);
	PanCamToPerson(Game.lithonite.GIP,16,16,true);

	// Save the old speed, and set the new speed to 8
	Movement_Update_wagon.oldspeed_normalX = Game.lithonite.speed_normalX;
	Movement_Update_wagon.oldspeed_normalY = Game.lithonite.speed_normalY;
	SetPersonSpeedXY( Game.lithonite.GIP,
		Game.lithonite.sX = Game.lithonite.speed_normalX = 8,
		Game.lithonite.sY = Game.lithonite.speed_normalY = 8
	);

	Game.pause.SetHookRenderScript("Render_Update_wagon()", 'wagon');
	Game.pause.SetHookUpdateScript("Movement_Update_wagon()", 'wagon');
	Game.pause.HookUpdateAndRender('wagon', 'wagon');

	Render_Update_wagon.tx = 0; // reset sneeky variables (used to check triggering triggers)
	Render_Update_wagon.ty = 0;
}

// Called from Movement_Update_wagon() when derailing, putting Daniel back on his feet.
function UnMountWagon(){

	// Hook back default update and render scripts
	Game.pause.HookUpdateAndRender();
	Game.lithonite.speed_normalX = Movement_Update_wagon.oldspeed_normalX;
	Game.lithonite.speed_normalY = Movement_Update_wagon.oldspeed_normalY;
	//SetPersonSpriteset(Game.lithonite.GIP ,LoadSpriteset("daniel.rss"));

	//Restore Daniel's spriteset and speed 
	Game.lithonite.LoadDirections(Daniel, 'default', true);
	Game.lithonite.rectifySpeed();

	PanCamToPerson(Game.lithonite.GIP, 16, 16, true);

	IgnoreTileObstructions(Game.lithonite.GIP, false);
	IgnorePersonObstructions(Game.lithonite.GIP, false);

	// While unmounting, put Daniel on an empty spot where he's not obstructed.
	if( !Game.lithonite.repos(0,0) ){
		for(var i=0;i<64;i+=16){
			for(var j=0;j<64;j+=16){
				if(
					Game.lithonite.repos(i,j) || 
					Game.lithonite.repos(-i,j) || 
					Game.lithonite.repos(-i,-j) || 
					Game.lithonite.repos(i,-j)
				) 
					break;
			}
			if(Game.lithonite.repos(0,0)) break;
		}
	}

	// Attach all, we are free to roam the map again.
	Game.lithonite.AttachAll();

}
